function [Rt, veclRt]=DCCeq(theta,data,optimizer)
% Calculate the time varying correlations based on the DCC(1,1)
% specification of Engle, given a parameters vector theta and a matrix of
% standardized iid residuals data
if nargin==2;
    optimizer='fmincon';
end
[T,N]=size(data);

if strcmp(optimizer,'fmincon')==1
    a=theta(1); b=theta(2);
elseif strcmp(optimizer,'fminunc')==1
    a=theta(1)^2/(1+theta(1)^2+theta(2)^2);
    b=theta(2)^2/(1+theta(1)^2+theta(2)^2);
end
Qt=zeros(N,N,T);
Qt(:,:,1)=cov(data);
Rt=zeros(N,N,T);
veclRt=zeros(T,N*(N-1)/2);
Rt(:,:,1)=corr(data);
for j=2:T
   Qt(:,:,j)=Qt(:,:,1)*(1-a-b);
   Qt(:,:,j)=Qt(:,:,j)+a*(data(j-1,:)'*data(j-1,:));
   Qt(:,:,j)=Qt(:,:,j)+b*Qt(:,:,j-1);
   Rt(:,:,j)=Qt(:,:,j)./(sqrt(diag(Qt(:,:,j)))*sqrt(diag(Qt(:,:,j)))');   
end
for j=1:T
veclRt(j,:)=rho2theta(Rt(:,:,j));
end
